/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.mods;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.jayjay.dangerzone.client.DZ2;
import net.jayjay.dangerzone.mods.BaseMod;
import net.jayjay.dangerzone.utils.DZ2Crash;

public class ModLoader {
    private static final String MODS_DIR = "mods";
    private static final String MAIN_CLASS_SUFFIX = "Main";
    private static List<BaseMod> mods = new ArrayList<BaseMod>();
    private static List<URLClassLoader> modClassLoaders = new ArrayList<URLClassLoader>();

    public static void addManually(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (!BaseMod.class.isAssignableFrom(clazz)) {
                System.err.println(String.valueOf(className) + " does not extend BaseMod");
                return;
            }
            BaseMod mod = (BaseMod)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            mods.add(mod);
            System.out.println("Loaded mod: " + className);
        }
        catch (ClassNotFoundException e2) {
            System.err.println("Class not found on classpath: " + className);
        }
        catch (Exception e3) {
            System.err.println("Failed to instantiate " + className);
            e3.printStackTrace();
        }
    }

    public static void loadMods() throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        File modsDir = new File(MODS_DIR);
        if (!modsDir.exists()) {
            modsDir.mkdirs();
            System.out.println("Created mods directory: " + modsDir.getAbsolutePath());
            return;
        }
        File[] jarFiles = modsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        if (jarFiles == null || jarFiles.length == 0) {
            System.out.println("No mod JARs found in " + modsDir.getAbsolutePath());
            return;
        }
        File[] fileArray = jarFiles;
        int n = jarFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File jarFile = fileArray[n2];
            Throwable throwable = null;
            Object var7_8 = null;
            try (JarFile jar = new JarFile(jarFile);){
                URL jarURL = jarFile.toURI().toURL();
                URLClassLoader classLoader = new URLClassLoader(new URL[]{jarURL}, ModLoader.class.getClassLoader());
                modClassLoaders.add(classLoader);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String className;
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".class") || !(className = entry.getName().replace("/", ".").replace(".class", "")).endsWith(MAIN_CLASS_SUFFIX)) continue;
                    try {
                        Class<?> clazz = classLoader.loadClass(className);
                        if (!BaseMod.class.isAssignableFrom(clazz)) continue;
                        BaseMod mod = (BaseMod)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        mod.setModClassLoader(classLoader);
                        mods.add(mod);
                        System.out.println("Loaded mod: " + className);
                    }
                    catch (Exception e2) {
                        System.err.println("Failed to load class " + className + ": " + e2.getMessage());
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++n2;
        }
    }

    public static void tickMods() {
        for (BaseMod mod : mods) {
            mod.tick();
        }
    }

    public static void tickKeyboard() {
        for (BaseMod mod : mods) {
            mod.keyboard();
        }
    }

    public static void runInits() {
        for (BaseMod mod : mods) {
            try {
                if (mod.versionBuiltWith().equals(DZ2.version)) {
                    System.out.println("Running preInit for " + mod.getClass().getSimpleName());
                    mod.preInit();
                } else {
                    System.err.println("This mod is out of date!\nMod is made for version " + mod.versionBuiltWith() + ", but we are running version " + DZ2.version);
                }
            }
            catch (Exception e2) {
                System.err.println("Error in preInit for " + mod.getClass().getSimpleName() + ": " + e2.getMessage());
                DZ2Crash.crashReport(e2);
            }
            try {
                System.out.println("Running init for " + mod.getClass().getSimpleName());
                mod.init();
            }
            catch (Exception e3) {
                System.err.println("Error in init for " + mod.getClass().getSimpleName() + ": " + e3.getMessage());
                DZ2Crash.crashReport(e3);
            }
            try {
                System.out.println("Running postInit for " + mod.getClass().getSimpleName());
                mod.postInit();
            }
            catch (Exception e4) {
                System.err.println("Error in postInit for " + mod.getClass().getSimpleName() + ": " + e4.getMessage());
                DZ2Crash.crashReport(e4);
            }
        }
    }

    public static void loadTextures() {
        for (BaseMod mod : mods) {
            try {
                System.out.println("Loading textures for " + mod.getClass().getSimpleName());
                mod.loadTextures();
            }
            catch (Exception e2) {
                System.err.println("Error loading textures for " + mod.getClass().getSimpleName() + ": " + e2.getMessage());
                DZ2Crash.crashReport(e2);
            }
        }
    }
}

